/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.tooltip;

import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.builder.AmmoItemBuilder;
import com.tacz.guns.client.input.RefitKey;
import com.tacz.guns.client.resource.ClientAssetManager;
import com.tacz.guns.client.resource.pojo.PackInfo;
import com.tacz.guns.config.sync.SyncConfig;
import com.tacz.guns.inventory.tooltip.GunTooltip;
import com.tacz.guns.item.GunTooltipPart;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.ExtraDamage;
import com.tacz.guns.util.AttachmentDataUtils;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ClientGunTooltip
implements class_5684 {
    private static final DecimalFormat FORMAT = new DecimalFormat("#.##%");
    private static final DecimalFormat DAMAGE_FORMAT = new DecimalFormat("#.##");
    private final class_1799 gun;
    private final IGun iGun;
    private final CommonGunIndex gunIndex;
    private final class_1799 ammo;
    @Nullable
    private List<class_5481> desc;
    private class_2561 ammoName;
    private class_5250 ammoCountText;
    @Nullable
    private class_5250 gunType;
    private class_5250 damage;
    private class_5250 armorIgnore;
    private class_5250 headShotMultiplier;
    private class_5250 tips;
    private class_5250 levelInfo;
    @Nullable
    private class_5250 packInfo;
    private int maxWidth;

    public ClientGunTooltip(GunTooltip tooltip) {
        this.gun = tooltip.getGun();
        this.iGun = tooltip.getIGun();
        class_2960 ammoId = tooltip.getAmmoId();
        this.gunIndex = tooltip.getGunIndex();
        this.ammo = AmmoItemBuilder.create().setId(ammoId).build();
        this.maxWidth = 0;
        this.getText();
    }

    public int method_32661() {
        int height = 0;
        if (this.shouldShow(GunTooltipPart.DESCRIPTION) && this.desc != null) {
            height += 10 * this.desc.size() + 2;
        }
        if (this.shouldShow(GunTooltipPart.AMMO_INFO)) {
            height += 24;
        }
        if (this.shouldShow(GunTooltipPart.BASE_INFO)) {
            height += 34;
        }
        if (this.shouldShow(GunTooltipPart.EXTRA_DAMAGE_INFO)) {
            height += 24;
        }
        if (this.shouldShow(GunTooltipPart.UPGRADES_TIP)) {
            height += 14;
        }
        if (this.shouldShow(GunTooltipPart.PACK_INFO)) {
            height += 14;
        }
        return height;
    }

    public int method_32664(class_327 font) {
        return this.maxWidth;
    }

    private void getText() {
        class_2960 gunId;
        PackInfo packInfoObject;
        String tooltip;
        class_327 font = class_310.method_1551().field_1772;
        if (this.shouldShow(GunTooltipPart.DESCRIPTION) && (tooltip = this.gunIndex.getPojo().getTooltip()) != null) {
            List split = font.method_1728((class_5348)class_2561.method_43471((String)tooltip), 200);
            this.desc = split.size() > 2 ? split.subList(0, 2) : split;
            for (class_5481 sequence : this.desc) {
                this.maxWidth = Math.max(font.method_30880(sequence), this.maxWidth);
            }
        }
        if (this.shouldShow(GunTooltipPart.AMMO_INFO)) {
            this.ammoName = this.ammo.method_7964();
            this.maxWidth = Math.max(font.method_27525((class_5348)this.ammoName) + 22, this.maxWidth);
            int barrelBulletAmount = this.iGun.hasBulletInBarrel(this.gun) && this.gunIndex.getGunData().getBolt() != Bolt.OPEN_BOLT ? 1 : 0;
            int maxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment(this.gun, this.gunIndex.getGunData()) + barrelBulletAmount;
            int currentAmmoCount = this.iGun.getCurrentAmmoCount(this.gun) + barrelBulletAmount;
            if (!this.iGun.useDummyAmmo(this.gun)) {
                this.ammoCountText = class_2561.method_43470((String)"%d/%d".formatted(currentAmmoCount, maxAmmoCount));
            } else {
                int dummyAmmoAmount = this.iGun.getDummyAmmoAmount(this.gun);
                this.ammoCountText = class_2561.method_43470((String)"%d/%d (%d)".formatted(currentAmmoCount, maxAmmoCount, dummyAmmoAmount));
            }
            this.maxWidth = Math.max(font.method_27525((class_5348)this.ammoCountText) + 22, this.maxWidth);
        }
        if (this.shouldShow(GunTooltipPart.BASE_INFO)) {
            int expToNextLevel = this.iGun.getExpToNextLevel(this.gun);
            int expCurrentLevel = this.iGun.getExpCurrentLevel(this.gun);
            int level = this.iGun.getLevel(this.gun);
            if (level >= this.iGun.getMaxLevel()) {
                levelText = String.format("%d (MAX)", level);
                this.levelInfo = class_2561.method_43471((String)"tooltip.tacz.gun.level").method_10852((class_2561)class_2561.method_43470((String)levelText).method_27692(class_124.field_1064));
            } else {
                levelText = String.format("%d (%.1f%%)", level, Float.valueOf((float)(expCurrentLevel / (expToNextLevel + expCurrentLevel)) * 100.0f));
                this.levelInfo = class_2561.method_43471((String)"tooltip.tacz.gun.level").method_10852((class_2561)class_2561.method_43470((String)levelText).method_27692(class_124.field_1054));
            }
            this.maxWidth = Math.max(font.method_27525((class_5348)this.levelInfo), this.maxWidth);
            String tabKey = "tacz.type." + this.gunIndex.getType() + ".name";
            this.gunType = class_2561.method_43471((String)"tooltip.tacz.gun.type").method_10852((class_2561)class_2561.method_43471((String)tabKey).method_27692(class_124.field_1075));
            this.maxWidth = Math.max(font.method_27525((class_5348)this.gunType), this.maxWidth);
            class_5250 value = class_2561.method_43470((String)DAMAGE_FORMAT.format((double)this.gunIndex.getBulletData().getDamageAmount() * (Double)SyncConfig.DAMAGE_BASE_MULTIPLIER.get())).method_27692(class_124.field_1075);
            if (this.gunIndex.getBulletData().getExplosionData() != null) {
                value.method_27693(" + ").method_27693(DAMAGE_FORMAT.format((double)this.gunIndex.getBulletData().getExplosionData().getDamage() * (Double)SyncConfig.DAMAGE_BASE_MULTIPLIER.get())).method_10852((class_2561)class_2561.method_43471((String)"tooltip.tacz.gun.explosion"));
            }
            this.damage = class_2561.method_43471((String)"tooltip.tacz.gun.damage").method_10852((class_2561)value);
            this.maxWidth = Math.max(font.method_27525((class_5348)this.damage), this.maxWidth);
        }
        if (this.shouldShow(GunTooltipPart.EXTRA_DAMAGE_INFO)) {
            @Nullable ExtraDamage extraDamage = this.gunIndex.getBulletData().getExtraDamage();
            if (extraDamage != null) {
                float armorDamagePercent = (float)((double)extraDamage.getArmorIgnore() * (Double)SyncConfig.ARMOR_IGNORE_BASE_MULTIPLIER.get());
                float headShotMultiplierPercent = (float)((double)extraDamage.getHeadShotMultiplier() * (Double)SyncConfig.HEAD_SHOT_BASE_MULTIPLIER.get());
                armorDamagePercent = class_3532.method_15363((float)armorDamagePercent, (float)0.0f, (float)1.0f);
                this.armorIgnore = class_2561.method_43469((String)"tooltip.tacz.gun.armor_ignore", (Object[])new Object[]{FORMAT.format(armorDamagePercent)});
                this.headShotMultiplier = class_2561.method_43469((String)"tooltip.tacz.gun.head_shot_multiplier", (Object[])new Object[]{FORMAT.format(headShotMultiplierPercent)});
            } else {
                this.armorIgnore = class_2561.method_43469((String)"tooltip.tacz.gun.armor_ignore", (Object[])new Object[]{FORMAT.format(0L)});
                this.headShotMultiplier = class_2561.method_43469((String)"tooltip.tacz.gun.head_shot_multiplier", (Object[])new Object[]{FORMAT.format(1L)});
            }
            this.maxWidth = Math.max(font.method_27525((class_5348)this.armorIgnore), this.maxWidth);
            this.maxWidth = Math.max(font.method_27525((class_5348)this.headShotMultiplier), this.maxWidth);
        }
        if (this.shouldShow(GunTooltipPart.UPGRADES_TIP)) {
            String keyName = class_2561.method_43472((String)RefitKey.REFIT_KEY.method_1431()).getString().toUpperCase(Locale.ENGLISH);
            this.tips = class_2561.method_43469((String)"tooltip.tacz.gun.tips", (Object[])new Object[]{keyName}).method_27692(class_124.field_1054).method_27692(class_124.field_1056);
            this.maxWidth = Math.max(font.method_27525((class_5348)this.tips), this.maxWidth);
        }
        if (this.shouldShow(GunTooltipPart.PACK_INFO) && (packInfoObject = ClientAssetManager.INSTANCE.getPackInfo(gunId = this.iGun.getGunId(this.gun))) != null) {
            this.packInfo = class_2561.method_43471((String)packInfoObject.getName()).method_27692(class_124.field_1078).method_27692(class_124.field_1056);
            this.maxWidth = Math.max(font.method_27525((class_5348)this.packInfo), this.maxWidth);
        }
    }

    public void method_32665(class_327 font, int pX, int pY, Matrix4f matrix4f, class_4597.class_4598 bufferSource) {
        int yOffset = pY;
        if (this.shouldShow(GunTooltipPart.DESCRIPTION) && this.desc != null) {
            yOffset += 2;
            for (class_5481 sequence : this.desc) {
                font.method_22942(sequence, (float)pX, (float)yOffset, 0xAAAAAA, false, matrix4f, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
                yOffset += 10;
            }
        }
        if (this.shouldShow(GunTooltipPart.AMMO_INFO)) {
            font.method_30882(this.ammoName, (float)(pX + 20), (float)(yOffset += 4), 0xFFAA00, false, matrix4f, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
            font.method_30882((class_2561)this.ammoCountText, (float)(pX + 20), (float)(yOffset + 10), 0x777777, false, matrix4f, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
            yOffset += 20;
        }
        if (this.shouldShow(GunTooltipPart.BASE_INFO)) {
            font.method_30882((class_2561)this.levelInfo, (float)pX, (float)(yOffset += 4), 0x777777, false, matrix4f, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
            yOffset += 10;
            if (this.gunType != null) {
                font.method_30882((class_2561)this.gunType, (float)pX, (float)yOffset, 0x777777, false, matrix4f, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
                yOffset += 10;
            }
            font.method_30882((class_2561)this.damage, (float)pX, (float)yOffset, 0x777777, false, matrix4f, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
            yOffset += 10;
        }
        if (this.shouldShow(GunTooltipPart.EXTRA_DAMAGE_INFO)) {
            font.method_30882((class_2561)this.armorIgnore, (float)pX, (float)(yOffset += 4), 0xFFAA00, false, matrix4f, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
            font.method_30882((class_2561)this.headShotMultiplier, (float)pX, (float)(yOffset += 10), 0xFFAA00, false, matrix4f, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
            yOffset += 10;
        }
        if (this.shouldShow(GunTooltipPart.UPGRADES_TIP)) {
            font.method_30882((class_2561)this.tips, (float)pX, (float)(yOffset += 4), 0xFFFFFF, false, matrix4f, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
            yOffset += 10;
        }
        if (this.shouldShow(GunTooltipPart.PACK_INFO) && this.packInfo != null) {
            font.method_30882((class_2561)this.packInfo, (float)pX, (float)(yOffset += 4), 0xFFFFFF, false, matrix4f, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
        }
    }

    public void method_32666(class_327 pFont, int pX, int pY, class_332 guiGraphics) {
        IGun iGun = IGun.getIGunOrNull(this.gun);
        if (iGun == null) {
            return;
        }
        if (this.shouldShow(GunTooltipPart.AMMO_INFO)) {
            int yOffset = pY;
            if (this.shouldShow(GunTooltipPart.DESCRIPTION) && this.desc != null) {
                yOffset += this.desc.size() * 10 + 2;
            }
            guiGraphics.method_51427(this.ammo, pX, yOffset + 4);
        }
    }

    private boolean shouldShow(GunTooltipPart part) {
        return (GunTooltipPart.getHideFlags(this.gun) & part.getMask()) == 0;
    }
}

